<?php

namespace App\Rules;

use Illuminate\Contracts\Validation\Rule;

class EmptySpace implements Rule
{
    /**
     * Create a new rule instance.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Determine if the validation rule passes.
     *
     * @param  string  $attribute
     * @param  mixed  $value
     * @return bool
     */
    public function passes($attribute, $value)
    {
        // return preg_match('/^(?!.*\s{2,}).*$/', $value);
        return preg_match('/^(?=.*[a-zA-Z])(?=\S*\s\S*$)(?!.*\s{2,}).*$/', $value);
    }

    /**
     * Get the validation error message.
     *
     * @return string
     */
    public function message()
    {
        return 'The :attribute must contain exactly one whitespace.';
    }
}
